<?php
include_once ("header.php");
	if(!$user_home->is_logged_in()) {
		$user_home->redirect('login.php');
	}
$message = "";
$alert = "";
if (!empty($_POST['action'])) {
    $name = $_POST["name"];
    $reverse = $_POST["reverse"];
    if (empty($name)) {
        $message = $lang['fill_all_data'];
        $alert = "alert alert-danger";
    } else {
        $today = date('YmdHis');
        $rand = rand(0, $today);
        $token = "table" . substr($rand, -5);
        if ($stmt = $user_home->prepareQuery("INSERT INTO leaderboards(name, token, reverse) VALUES(?, ?, ?)")) {
            $stmt->bind_param('ssi', $name, $token, $reverse);
            if ($stmt->execute()) {
                if ($stmt = $user_home->prepareQuery("CREATE TABLE IF NOT EXISTS {$token}_scores (
	  `user_id` varchar(64) NOT NULL,
	  `name` varchar(256) NOT NULL,
	  `table_id` int(11) NOT NULL,
	  `score` bigint(30) NOT NULL,
	  `add_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	  PRIMARY KEY (`user_id`),
	  UNIQUE KEY `user_id` (`user_id`),
	  KEY `table_id` (`table_id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;")) {
                    if ($stmt->execute()) {
                        if ($stmt = $user_home->prepareQuery("ALTER TABLE `{$token}_scores` ADD CONSTRAINT `{$token}_scores` FOREIGN KEY (`table_id`) REFERENCES leaderboards(id) ON DELETE CASCADE ON UPDATE CASCADE;")) {
                            if ($stmt->execute()) {
                                $message = $lang['leaderboard_created'];
                                $alert = "alert alert-success";
                            }
                        }
                    }
                }
            } else {
                $message = $lang['database_error'];
                $alert = "alert alert-danger";
            }
        }
    }
}
?>
	<?php if (!empty($message)) { ?>
		<div id="message">
			<div class="<?=$alert
?>" id="alert">
				<?=$message
?>
			</div>
		</div>
	<?php
} ?>
		<div class="row">
			<div class="col-12">
				<div class="widget">
					<div class="widget-header"> <i class="icon-plus-sign"></i>
						<h3> <?= $lang['add_leaderboard']; ?></h3>
					</div>
					<div class="widget-content">
						<form action="" method="POST">
							<input type="hidden" id="action" name="action" value="create" />
							<div class="form-group">
								<label for="name"><?= $lang['leaderboard_name']; ?></label>
								<input type="text" id="name" class="form-control" name="name" required>
								<label for="reverse"><?= $lang['leaderboard_reverse']; ?></label>
								<select name="reverse" id="reverse" class="custom-select" style="width: 100%">
									<option value="0"><?= $lang['high_to_low']; ?></option>
									<option value="1"><?= $lang['low_to_high']; ?></option>
								</select>
							</div>
							<button type="submit" class="btn btn-primary"><?=$lang['add_leaderboard']; ?></button>
						</form>
					</div>
				</div>
			</div>
	  </div>
<?php include_once ('footer.php'); ?>